# 画面設計書 41-kubectl api-versions

## 概要

本ドキュメントは、kubectlのapi-versionsコマンドの画面設計書である。Kubernetes API ServerがサポートするAPIバージョンの一覧を「group/version」形式で標準出力に表示するCLIコマンドの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：Kubernetesクラスタでは多数のAPIグループとバージョンが存在し、環境やバージョンによって利用可能なAPIが異なる。api-versionsコマンドは、現在のクラスタがサポートするAPIバージョンを素早く確認するために必要であり、マニフェスト作成時のapiVersion指定やトラブルシューティングにおいて重要な役割を果たす。

**画面へのアクセス方法**：ターミナルから `kubectl api-versions` を実行する。引数は受け付けない（`cobra.NoArgs`に相当する処理）。

**主要な操作・処理内容**：
1. DiscoveryClientを通じてAPI Serverから利用可能なAPIグループ情報を取得する
2. `discoveryClient.Invalidate()` により常にサーバから最新データを取得する
3. `discoveryClient.ServerGroups()` でグループ一覧を取得する
4. `metav1.ExtractGroupVersions()` でgroup/version文字列を抽出する
5. 結果をアルファベット順にソートして1行ずつ標準出力に出力する

**画面遷移**：CLIコマンドであるため画面遷移は存在しない。kubectlルートコマンドの「Other Commands」カテゴリに属する。

**権限による表示制御**：kubeconfigに設定されたユーザーの認証情報を使用してAPI Serverにアクセスするため、認証に失敗した場合はエラーとなる。APIグループの発見（Discovery）自体は通常認可制限が少ないが、クラスタ設定によっては制限される可能性がある。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 109 | API Resources表示 | 主機能 | サポートされるAPIバージョンの一覧を表示する主処理 |
| 1 | API Serverコア | API連携 | APIバージョン一覧取得のためAPI Serverにリクエストを送信する |

## 画面種別

一覧（CLIテキスト出力）

## URL/ルーティング

```
kubectl api-versions
```

コマンドエイリアスやショートカットは存在しない。

## 入出力項目

### 入力項目（フラグ）

本コマンド固有のフラグは存在しない。kubectlグローバルフラグ（--kubeconfig, --context, --server等）のみ利用可能。

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| （引数） | - | 不可 | - | 引数を受け付けない。指定するとエラーとなる |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|------|------|
| APIバージョン | string | 「group/version」形式の文字列（例：apps/v1, v1） |

## 表示項目

出力は1行1バージョンの単純なテキスト形式である。

```
admissionregistration.k8s.io/v1
apiextensions.k8s.io/v1
apiregistration.k8s.io/v1
apps/v1
...
v1
```

## イベント仕様

### 1-コマンド実行

1. `Complete` メソッドにて引数のバリデーション（引数ゼロであること）とDiscoveryClientの初期化を行う
2. `RunAPIVersions` メソッドにてDiscoveryClientのキャッシュを無効化し、常にサーバから最新データを取得する
3. `ServerGroups()` でAPIグループ一覧を取得する
4. `ExtractGroupVersions()` でgroup/version文字列リストを抽出する
5. ソート後に標準出力に出力する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| コマンド実行 | なし | SELECT（読取のみ） | API Serverからデータを取得するのみで更新は行わない |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| ERR-01 | エラー | `couldn't get available api versions from server: %v` | ServerGroups()呼び出し失敗時 |
| ERR-02 | エラー | `unexpected arguments: %v` | 引数が指定された場合 |

## 例外処理

- API Serverへの接続に失敗した場合、DiscoveryClientのエラーが表示される
- 引数が指定された場合、UsageErrorが返される
- kubeconfig未設定の場合、RESTClientGetter初期化時にエラーが発生する

## 備考

- api-versionsコマンドはapi-resourcesコマンドと同一パッケージ（apiresources）内に実装されている
- `DisableFlagsInUseLine: true` が設定されており、ヘルプ表示でフラグ情報を表示しない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

APIバージョン取得に使用されるオプション構造体と、APIレスポンスの型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | apiversions.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiversions.go` | APIVersionsOptions構造体（行41-45）にdiscoveryClientとIOStreamsが含まれることを確認する |

**読解のコツ**: cobraのCommand構造とOptions構造体の関係を理解すること。Complete->Validate->Runのパターンに注目する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | apiversions.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiversions.go` | NewCmdAPIVersions関数（行55-69）がcobra.Commandを構築する。Run内でComplete->RunAPIVersionsの順に呼ばれる |

**主要処理フロー**:
1. **行63-64**: Complete→RunAPIVersionsの順序でエラーチェック付き呼び出し
2. **行72-79**: Complete()でDiscoveryClientを初期化
3. **行82-96**: RunAPIVersions()でサーバからグループ一覧を取得しソートして出力

#### Step 3: Discovery API呼び出しを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | discovery パッケージ | `staging/src/k8s.io/client-go/discovery/` | CachedDiscoveryInterfaceのServerGroups()メソッドがAPI Serverの /apis エンドポイントを呼び出す |

### プログラム呼び出し階層図

```
NewCmdAPIVersions (apiversions.go:55)
    |
    +-- cobra.Command.Run
           |
           +-- Complete (apiversions.go:72)
           |       +-- restClientGetter.ToDiscoveryClient()
           |
           +-- RunAPIVersions (apiversions.go:82)
                   +-- discoveryClient.Invalidate() (行84)
                   +-- discoveryClient.ServerGroups() (行86)
                   +-- metav1.ExtractGroupVersions() (行90)
                   +-- sort.Strings() (行91)
                   +-- fmt.Fprintln() (行92-93)
```

### データフロー図

```
[入力]               [処理]                    [出力]

(なし) ──────> DiscoveryClient ──────> stdout
               .ServerGroups()         (group/version一覧)
               .ExtractGroupVersions()
               sort.Strings()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| apiversions.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiversions.go` | ソース | api-versionsコマンド本体の実装 |
| apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | ソース | 同一パッケージ内のapi-resourcesコマンド実装 |
| discovery.go | `staging/src/k8s.io/client-go/discovery/discovery_client.go` | ソース | DiscoveryClientインターフェースの実装 |
